import os
import time
from pipelines.prompta.oracle.base_oracle import BaseOracle


class BaseLearner:
    ID = "BaseLearner"

    def __init__(
            self,
            oracle: BaseOracle,
            exp_dir: str
            ) -> None:
        self.oracle = oracle
        self.save_folder = exp_dir

    def learn(self):
        raise NotImplementedError
    
    def set_save_folder_name(self):
        # timestamp = time.strftime("%Y%m%d-%H%M%S")
        if not os.path.exists(self.save_folder):
            os.makedirs(self.save_folder)
        
    def get_dfa_name(self):
        return f'{self.oracle.language.context_name}.taf'

    def get_dfa_save_path(self):
        return os.path.join(self.save_folder, self.get_dfa_name())
    
    @staticmethod
    @property
    def name():
        return __class__.ID
